<{* Publisher Top Games Template - Oyun Listesi Görünümü *}>

<{if $publisher_count > 0}>
    <div class="top-games-container">
        <div class="games-grid">
            <{foreach item=game from=$publisher_items}>
                <div class="game-card">
                    <{if $game.image}>
                        <div class="game-thumbnail">
                            <a href="<{$game.link}>" title="<{$game.title}>">
                                <img src="<{$game.image}>" alt="<{$game.title}>" />
                                <div class="game-overlay">
                                    <span class="play-icon">▶</span>
                                </div>
                            </a>
                        </div>
                    <{/if}>
                    
                    <div class="game-info">
                        <h4 class="game-title">
                            <a href="<{$game.link}>" title="<{$game.title}>">
                                <{$game.title}>
                            </a>
                        </h4>
                        
                        <div class="game-rating">
                            <{if $game.votes > 0}>
                                <div class="stars">
                                    <{assign var="fullStars" value=$game.rating|floor}>
                                    <{section name=star loop=5}>
                                        <{if $smarty.section.star.index < $fullStars}>
                                            <span class="star filled">★</span>
                                        <{else}>
                                            <span class="star">☆</span>
                                        <{/if}>
                                    <{/section}>
                                </div>
                                <div class="rating-text">
                                    <strong><{$game.rating}></strong> / 5.0
                                    <span class="votes">(<{$game.votes}> oy)</span>
                                </div>
                            <{else}>
                                <div class="no-rating">
                                    <span class="star">☆☆☆☆☆</span>
                                    <span class="votes">Henüz oylanmamış</span>
                                </div>
                            <{/if}>
                        </div>
                        
                        <div class="game-stats">
                            <span class="views">
                                <i class="fa fa-eye"></i> <{$game.counter}> görüntülenme
                            </span>
                        </div>
                        
                        <{if $game.summary}>
                            <div class="game-description">
                                <{$game.summary|truncate:100:"..."}>
                            </div>
                        <{/if}>
                        
                        <div class="game-actions">
                            <a href="<{$game.link}>" class="btn-play">
                                <i class="fa fa-gamepad"></i> Oyna
                            </a>
                        </div>
                    </div>
                </div>
            <{/foreach}>
        </div>
    </div>
<{else}>
    <div class="no-games">
        <p>Henüz oyun eklenmemiştir.</p>
    </div>
<{/if}>

<style>
.top-games-container {
    padding: 20px 0;
}

.games-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 25px;
}

.game-card {
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.game-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.game-thumbnail {
    position: relative;
    width: 100%;
    padding-top: 66.67%; /* 3:2 aspect ratio */
    overflow: hidden;
    background: #f0f0f0;
}

.game-thumbnail img {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s ease;
}

.game-card:hover .game-thumbnail img {
    transform: scale(1.1);
}

.game-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.game-card:hover .game-overlay {
    opacity: 1;
}

.play-icon {
    font-size: 48px;
    color: #fff;
}

.game-info {
    padding: 15px;
}

.game-title {
    margin: 0 0 10px 0;
    font-size: 18px;
    font-weight: 600;
}

.game-title a {
    color: #333;
    text-decoration: none;
}

.game-title a:hover {
    color: #0066cc;
}

.game-rating {
    margin-bottom: 10px;
}

.stars {
    margin-bottom: 5px;
}

.star {
    color: #ddd;
    font-size: 18px;
    margin-right: 2px;
}

.star.filled {
    color: #ffd700;
}

.rating-text {
    font-size: 14px;
    color: #666;
}

.rating-text strong {
    color: #333;
    font-size: 16px;
}

.votes {
    color: #999;
    font-size: 12px;
    margin-left: 5px;
}

.no-rating {
    color: #999;
    font-size: 13px;
}

.game-stats {
    margin-bottom: 10px;
    padding-bottom: 10px;
    border-bottom: 1px solid #f0f0f0;
    font-size: 13px;
    color: #777;
}

.game-description {
    margin-bottom: 15px;
    font-size: 14px;
    line-height: 1.5;
    color: #666;
}

.game-actions {
    text-align: center;
}

.btn-play {
    display: inline-block;
    width: 100%;
    padding: 12px 20px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
    text-decoration: none;
    border-radius: 5px;
    font-weight: 600;
    transition: transform 0.2s ease;
}

.btn-play:hover {
    transform: scale(1.02);
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
}

.btn-play i {
    margin-right: 5px;
}

.no-games {
    padding: 60px 20px;
    text-align: center;
    color: #999;
    font-size: 16px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .games-grid {
        grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        gap: 15px;
    }
    
    .game-info {
        padding: 12px;
    }
    
    .game-title {
        font-size: 16px;
    }
}

@media (max-width: 480px) {
    .games-grid {
        grid-template-columns: 1fr;
    }
}
</style>
